var PageLS = {
	get: function(name){
		if (!window.localStorage) return undefined;
		var item = window.localStorage.getItem(name);
		try {
			return JSON.parse(item);
		} catch(e) {
			return item;
		}
	},
	set: function(name,data){
		if (!window.localStorage) return;
		window.localStorage.setItem(name,JSON.stringify(data));
	}
}
/**
 * Class: Page
 */

/**
 * Method: new
 */
function Page(config) {}

/**
 * Method: init
 */
Page.prototype.init = function(config){
	var _config = {
		api_url:	'/api/mobile/',
		index_view:	'index',
		title:		'SGSystems'
	};
	
	this.config = config || {};
	
	for (k in _config) if(!this.config[k]) this.config[k] = _config[k];
	
	try {
		this.name = this.my_name();
	} catch(e) {
		throw 'Important! No my_name method added for Page.prototype extension!';
	}
}

Page.prototype.LS = PageLS;

/**
 * Method: open
 */
Page.prototype.open = function(){
	
	this.before_open();
	return this.gen_layout();
}

/**
 * Method: before_open
 */
Page.prototype.before_open = function(v){
	// TO REDEFENITION
}

/**
 * Method: gen_layout
 */
Page.prototype.gen_layout = function(){
	
	var t = this;
	
	var buttons_top = [];
	if (!this.config.no_back) {
		buttons_top.push({pos:0, name:"", cssclass:"back image", click:function(){
				if(t.back_confirm() || confirm('Есть несохраненные данные! Продолжить?')) pager.back();
			}
		});
	}
	
	var ret={
		
		top: {
			buttons:	buttons_top,
			title: 		this.config.title,
		},
		
		html: this.get_view('index'),

	};
	
	this.set_index(ret);
	this.gen_layout_custom(ret);
	
	return ret;
}

/**
 * Method: gen_layout_custom
 */
Page.prototype.gen_layout_custom = function(ret){
	// TO REDEFENITION
}

/**
 * Method: set_index
 */
Page.prototype.set_index = function(ret){
	// TO REDEFENITION
	if (this.config.page_index) ret.page_index = this.config.page_index;
}

/**
 * Method: get_view
 */
Page.prototype.get_view = function(view_name){
	return lnrr.View(this.get_view_path(view_name));
}

/**
 * Method: get_view_path
 */
Page.prototype.get_view_path = function(view_name){
	return 'mobile/' + this.name + '/' +(this.config[view_name+'_view'] || view_name);
}

/**
 * Method: on_page_added
 */
Page.prototype.on_page_added = function(v){
	this.init_html();
	this.to_center();
	this.after_page_added();
}

/**
 * Method: init_html
 */
Page.prototype.init_html = function(){
	
	this.html = pager.get_html(this.page_index);
	this.page = pager.get_page(this.page_index);
	
	this.blocks = {
		log:	$('._page_log',this.html),
		error:	$('._page_error',this.html),
		loader:	$('.LNMPager-top .title',this.page),
		state:  $('._page_state',this.html),
		result:  $('._page_result',this.html),
		_centered:$('._to_center',this.html),
	};
	
	this.timers = {
		log: 		 1500,
		error:		 5000,
		aftersubmit: 2500
	};
	
}

/**
 * Method: to_center
 */
Page.prototype.to_center=function(v){
	if (!this.blocks._centered.length) return;
	var m_height = this.html.height();
	var c_height = this.blocks._centered.height();
	
	var top;
	if (c_height < m_height) top = (m_height - c_height)/2;
	this.blocks._centered.css({ 'margin-top' : top || 'initial' })
}

/**
 * Method: on_page_added_custom
 */
Page.prototype.after_page_added=function(v){
	// TO REDEFENITION
}

/**
 * Method: request
 */
Page.prototype.request = function(mode,data,success,error){
	
	if (!mode) throw 'No mode';
	
	var t = this;
	
	if (this.pending) {
		this.error('Загрузка не завершена');
		return;
	}
	
	var request_data = this.fill_request_data(data);
	
	this.set_pending(1, true);
	
	console.log('send request -> ',request_data);

	$.ajax({
		url:		this.get_api_url(mode),
		method:		'POST',
		dataType:	'json',
		data:		request_data,	// todo -> send auth data?
		success: 	function(r){
			console.log('response data -> ',r);
			t.set_pending(0, true);
			if (success) success(r,data);
		},
		error: function(e){
			console.log('response error -> ',e);
			t.set_pending(0);
			var text = (e && e.responseText) || ((e && e.status==0) ? 'Отсутствует подключение к интернет' : 'Не известная ошибка');
			t.error('Не удалось загрузить данные <br> ' + text, 1);
			if (error) error(e,data);
		}
	})
}

/**
 * Method: error
 */
Page.prototype.error=function(text, clear_log){
	
	var t = this;
	
	this.blocks.error.html(text);
	clearTimeout(this.error_tid);
	
	this.error_tid = setTimeout(function(){
		t.blocks.error.html('');
	},this.timers.error);
	
	if (clear_log) this.log('');
}


/**
 * Method: log
 */
Page.prototype.log = function(text,clear_error){
	
	var t = this;
	
	clearTimeout(this.log_tid);
	this.blocks.log.html(text);
	
	this.log_tid = setTimeout(function(){
		console.log('setTimeout');
		t.blocks.log.html('');
	},this.timers.log);
	
	if (clear_error) this.error('');
}


/**
 * Method: fill_request_data
 */
Page.prototype.fill_request_data = function(data){
	
	data = data || {};
	
	data.ajaj = 1;
	
	if (data.need_auth) {		
		data.login = localStorage.getItem('login');
		data.password = localStorage.getItem('password');
		data['do-login'] = 1;
	}
	
	data.server = this.get_api_url('');
	
	return data;
}

/**
 * Method: set_pending
 */
Page.prototype.set_pending=function(v,need_log){
	this.pending = v;
	this.set_loader(v);	
	if (need_log) this.log(this.pending ? 'Загрузка данных началась' : 'Загрузка данных завершена', 1);
}

/**
 * Method: set_loader
 */
Page.prototype.set_loader=function(v){
	this.blocks.loader[!v ? 'removeClass' : 'addClass']('A');
}

/**
 * Method: get_api_url
 */
Page.prototype.get_api_url = function(api){
	return 'http://' + window.localStorage.getItem("server") + this.config.api_url + api + '/';
}


/**
 * Method: on_page_focus
 */
Page.prototype.on_page_focus = function(){
	
	if (this.config.refresh_on_focus) {
		this.before_open();
		pager.set_html(this.page_index,this.get_view('index'));
		this.init_html();
	} else this.refresh();
	
	this.to_center();
}

/**
 * Method: refresh
 */
Page.prototype.refresh = function(){
	// TO REDEFENITION
}


/**
 * Method: back_confirm
 */
Page.prototype.back_confirm = function(){
	// TO REDEFENITION
	return true;
}

/**
 * Method: save_image
 */
Page.prototype.save_image = function(image, callback){
	
	var t = this;
	
	if (!window.rootFS) return;
	if (t.pending) return;
	
	t.set_pending(1);
	
	window.rootFS.getDirectory("images", {create: true, exclusive: false}, function(dir){
		
		var image_url = image.url;
		var image_path = dir.nativeURL + image.id + image.url.match(/(\.\w+)$/)[1];
		
		console.log('download',image_url);
		console.log('to',image_path);
		
		var fileTransfer = new FileTransfer();
		
		fileTransfer.download(
			image_url,
			image_path,
			function(theFile) {
				console.log("download complete: " + theFile.toURI());
				var cached_images = t.LS.get('images') || {};				
				cached_images[image.id] = theFile.toURI();
				t.LS.set("images",cached_images);
				t.set_pending(0);
				if (callback) callback();
			},
			function(error) {
				console.log('upload error: ',error);
				t.set_pending(0);
				if (callback) callback();
			}
		);
		
	}, fail);
}