#ifndef ATOMS_TYPES_H
#define ATOMS_TYPES_H

#include <stdlib.h>
#include <string.h>
#include <assert.h>

#ifdef __GNUC__
#ifndef __APPLE__
#include <linux/types.h>
#define uint8 __u8
#define int8 __s8
#define uint16 __u16
#define int16 __s16
#define uint32 __u32
#define int32 __s32
#define uint64 __u64
#define int64 __s64

// TODO
#define ptrsize uint64

#endif
#endif

#ifdef __APPLE__
#define uint8 unsigned char
#define int8 signed char
#define uint16 unsigned short int
#define int16 signed short int
#define uint32 unsigned int
#define int32 signed int
#define uint64 unsigned long long
#define int64 signed long long

// TODO
#define ptrsize uint64

#endif

#define PTR_WORD_ALIGN 4

#endif
