#ifndef ATOMS_FILE_H
#define ATOMS_FILE_H

#include <stdio.h>
#include <atoms/object.h>
#include <atoms/text8.h>
#include <atoms/text32.h>
#include <atoms/bytestream.h>

#define FILE_OPEN_RO 1
#define FILE_OPEN_RW 2
#define FILE_OPEN_A 3
/*! \brief Класс для работы с файлами
 *  \ingroup atoms
 *
 */
class File: public ByteStream {
public:
	File();
	File(Text *_name);
	virtual ~File();

	/*! \brief Открывает файл
	 */
	virtual bool open(uint8 open_type=FILE_OPEN_RO);
	
	/*! \brief Закрывает файл
	 */
	virtual bool close();

	/*! \brief Устанавливает имя файла
	 */
	virtual void set_filename(Text *text);

	/*! \brief Считывает ВЕСЬ файл, возвращая указатель
	 */
	virtual char *read_file_to_ptr(uint64 &size);
	
	/*! \brief Считывает ВЕСЬ файл, возвращая Text8
	 */
	virtual Text8 *read_file_text8();
	
	/*! \brief Считывает ВЕСЬ файл, возвращая Text32
	 */
	virtual Text32 *read_file_text32();

	/*! \brief Считывает ВЕСЬ файл, возвращая Blob
	 */
	virtual Blob *read_file_blob();

	/*! \brief Считывает строку до разделителя или конца файла
	 */
	virtual Text8 *read_string_text8(uint32 limiter='\n');

	/*! \brief Считывает строку до разделителя или конца файла
	 */
	virtual Text32 *read_string_text32(uint32 limiter='\n');

	/*! \brief Считывает строку до разделителя или конца файла
	 */
	virtual Blob *read_string_blob(uint32 limiter='\n');
	
	/*! \brief Считывает из файла символы, пока они цифры (или +/-). Интерпретирует как целое число
	 */
	virtual long long atoll();

	/*! \brief Сохраняет Text, перезаписывая ВЕСЬ файл
	 */
	virtual void save_file_text(Text *t);

	/*! \brief Сохраняет Text в открытый файл, перезаписывая секцию
	 */
	virtual void save_string(Text *t);

	/*! \brief Возвращает размер файла
	 */
	virtual uint64 file_size();
	
	/*! \brief Возвращает текущую позицию
	 */
	virtual uint64 tell();
	
	/*! \brief Устанавливает указатель на позицию
	 */
	virtual void seek(uint64 ptr,uint8 type=SEEK_SET);
	
	/*! \brief Читает блок (кластер)
	*/
	//virtual bool read_block(uint32 blocksize=8192);
	
	virtual void putc(uint8 c, uint64 offset);

	virtual const char *classname();
	

	Text *filename;
	FILE *file;
};

#endif
