#ifndef STREAMS_H

#define STREAMS_H

#include "omatoms.h"

class ReadStream: public Object {
	private:
		unsigned char*src_ptr;
		unsigned char*ptr;
		int32 ptr_len;

	public:
		ReadStream(unsigned char*ptr,int32 ptr_len);
		virtual ~ReadStream();

		virtual int64 read_int64();
		virtual int32 read_int32();
		virtual void read_ip(char *ip);
		virtual char*read_charptr();
		virtual int32 get(void);
		virtual void set(int32);
		virtual int32 len();
		virtual const char *classname();
};

class WriteStream {
	private:
		unsigned char *ptr;
		FILE *out;
		bool do_free;
		
	public:
		unsigned char *src_ptr;
		int32 ptr_len;

		WriteStream();
		WriteStream(unsigned char *_ptr,int _len);
		virtual ~WriteStream();

		virtual void grow(int32 a);
		virtual void check_grow(int32 i);
		virtual void file_open(const char *filename);
		virtual void write_int32(int32 i);
		virtual void write_int64(int64 i);
		virtual void write_ip(char *ip);
		virtual void write_charptr(const char *a);

		virtual void set(int32 a);
		virtual int32 get();
		virtual int32 len();

		virtual int64 read_int64();
		virtual int32 read_int32();
		virtual const char *classname();
};

#endif

