#ifndef TRACKER_H
#define TRACKER_H

#include "omatoms.h"
#include <evhttp.h>

#define MODE_INDEX		1
#define MODE_GIF		2
#define MODE_JS			3
#define MODE_AJAX		4
#define MODE_POSTBACK	5
#define MODE_SYSTEM		6
#define MODE_OFFERWALL	7
#define MODE_SMARTPOPUP	8
#define MODE_SMARTOFFER	9

#define TMPSTR_MAX 20480
#define OIS_PRESELECTED_MAX 20

class Memcache;
class Writer;
class UserPostback;
class UserPostbacks;
class ScanStruct;
class OfferInfo;

class Tracker:public Object {
/*	friend Writer;
	friend UserPostback;
	friend UserPostbacks;
	friend void scan(int argc,char **argv);
	friend void scan_on_each_row(int pos,Tracker *tr,ScanStruct *ss);*/

	public:
		evhttp_request*	req;
		struct evbuffer *	evb;

		int32			mode;
		const char *	ip_str;
		char			ip[12];
		const char*		ua;
		int64			region_id;
		int64			device_id;
		int64			user_agent_id;
		int32			checks;

		const char *	foreign_clickid;

		// must-be fields
		int64			offer_id;
		int64			user_id;

		// possible fields
		// user-supplied params
		int64			smartlink_id;
		int64			smartlink_offer_id;

		const char *	aff_source;
		const char *	aff_sub;
		const char *	aff_sub2;
		const char *	aff_sub3;
		const char *	aff_sub4;
		const char *	aff_sub5;
		const char *	aff_pb;
		const char *	referer;		// TODO
		float			payout_db_usd;	// TODO
		float			payout_db;		// TODO
		float			payout_db_aff;	// TODO
		int32			currency_db_id;	// TODO

		// GIF FIELDS
		int32			gif_rnd;

		// JS FIELDS
		const char*		js_ua;
		int64			js_user_agent_id;
		int32			js_width;
		int32			js_height;

		// PAYOUT FIELDS
		float			payout_http;
		int64			payout_user_agent_id;
		int64			payout_date;
		char			payout_ip[12];
		float			db_payout;
		int32			db_currency_id;

	public:
		// almost must-be fields
		int64			click_date;
		const char*		clickid_str;
		int				clickid_entryno;
		int				clickid_fileno;
		int				clickid_nodeno;


		int				force_device_id;
		int				force_region_id;

		unsigned char 	*free_on_delete;
		const char*		content_type;
		

		bool			ignore_device;
		bool			ignore_region;

		OfferInfo		**ois_preselected;
		int				ois_preselected_pos;
	public:
		Tracker();
		virtual ~Tracker();


		virtual void init();
		virtual void init(evhttp_request *req);
		virtual void init(int32 mode,const char*ip,const char*ua,int64 offer_id,int64 user_id,const char *foreign_clickid,const char*clickid_str=NULL,int64 smartlink_id=0,int64 smartlink_offer_id=0,float payout=0);
		virtual void parse();
		virtual void dump();
		virtual void calc_db_payouts(OfferInfo *oi);
		virtual void work();
		virtual void work__sysredirect(OfferInfo*oi);
		virtual void work__index();
		virtual void work__offerwall();
		virtual void work__gif();
		virtual void work__js();
		virtual void work__ajax();
		virtual void work__postback();
		virtual void work__system();
		virtual void work__smartpopup();
		virtual void work__smartoffer();
		virtual void work__error(const char*);
		virtual void evbuffer_dump();
		virtual void evbuffer_send();
		virtual const char *classname();

		virtual void html_header(const char *header);
		virtual void html_footer();

		virtual void ois_preselected_init();
		virtual bool ois_preselected_push(OfferInfo *oi,int64 slo_id);
		virtual OfferInfo *ois_preselected_get_random();
		virtual void ois_preselected_free();

};
#endif
