#include <atoms/int64.h>
#include <atoms/blob.h>

/*****************************************************************************/
Int64::Int64()
{
	value=0;
}

/*****************************************************************************/
Int64::Int64(int64 v)
{
	value=v;
}

/*****************************************************************************/
Int64::~Int64()
{

}

/*****************************************************************************/
const char *Int64::classname(void)
{
	return "Int64";
}

/*****************************************************************************/
int8 Int64::cmp(Object *c)
{
	Int64 *c1=dynamic_cast<Int64*>(c);
	if (c1) {
		if (c1->value==value) return 0;
		return (value<c1->value)?-1:1;
	} else {
		return Object::cmp(c);
	}
}

/*****************************************************************************/
bool Int64::storable_to_blob(Blob *b)
{
	b->add_bytes((const uint8*)(&value),8);
	b->word_align();
	return false;
}

/*****************************************************************************/
