#include <atoms.h>

//#define STORABLE_DEBUG

#define BLOB_ARRAY		1
#define BLOB_HASH		2
#define BLOB_STRING		3
#define BLOB_INT64		4
#define BLOB_DOUBLE		5
#define BLOB_NULL		6

#define ARRAY_START 	1
#define ARRAY_ITER		2
#define ARRAY_END		3
#define HASH_START		4
#define HASH_ITER		5
#define HASH_KEY		6
#define HASH_END		7
#define OBJ_INT64		8
#define OBJ_STRING		9
#define OBJ_DOUBLE		10
#define OBJ_NULL		11

Storable *storable;

/*****************************************************************************/
void storable_init(void)
{
	storable=new Storable();
}

/*****************************************************************************/
Storable::Storable()
{
	from_blobs=new Array();from_blobs->add_ref();
}

/*****************************************************************************/
Storable::~Storable()
{
	from_blobs->del_ref();
}
		
/*****************************************************************************/
const char *Storable::classname()
{
	return "Storable";
}

/*****************************************************************************/
void Storable::set_from_blob_constructor(uint32 code,StorableFromBlob *f)
{
	from_blobs->put(code,f);
}

/*****************************************************************************/
Text8 *Storable::to_json(Object *o)
{

}

/*****************************************************************************/
Object *Storable::from_json(Text8 *src)
{

}
		
/*****************************************************************************/
Blob *Storable::to_blob(Object *o)
{
	Blob *b=new Blob();
	bool err=o->storable_to_blob(b);
	if (err) {
		b->add_ref();
		b->del_ref();
		return NULL;
	}
	return b;
}

/*****************************************************************************/
Object *Storable::from_blob(Blob *b)
{
	return from_blob(b->text,b->length);
}

/*****************************************************************************/
Object *Storable::from_blob(const uint8 *src,uint32 len)
{
	uint32 posinc=0;
	uint8 error;
	Object *o=from_blob_item(src,len,posinc,error);
	if (posinc!=len || error) {
		if (o) delete o;
		return NULL;
	}
	return o;
}

/*****************************************************************************/
Object *Storable::from_blob_item(const uint8 *src,uint32 len,uint32 &posinc,uint8 &error,uint32 level)
{
	error=0;
	posinc=0;
	uint32 slen;
	uint32 slen2;
	uint32 posinc2;
	uint32 i;
#ifdef STORABLE_DEBUG
	for (i=0;i<level;i++) printf("  ");
#endif
	if (len<4) {error=1;return NULL;}
	uint32 otype=((uint32*)src)[0];

	Array *arr;
	Hash *h;
	Text *t;
	Object *v;
	StorableFromBlob *fr;
	switch (otype) {
		case BLOB_ARRAY:
			if (len<4+8) {error=1;return NULL;}
			slen=((uint32*)src)[1];
#ifdef STORABLE_DEBUG
			printf("Storable::from_blob_item: ARRAY (%d)\n",slen);
#endif
			posinc=8;
			arr=new Array();
			for (i=0;i<slen;i++) {
				arr->push(from_blob_item(src+posinc,len-posinc,posinc2,error,level+1));
				if (error) {delete arr;return NULL;}
				posinc+=posinc2;
			}
			return arr;
			break;
		case BLOB_HASH:
			if (len<4+8) {error=1;return NULL;}
			slen=((uint32*)src)[1];
#ifdef STORABLE_DEBUG
			printf("Storable::from_blob_item: HASH (%d)\n",slen);
#endif
			posinc=8;
			h=new Hash();
			for (i=0;i<slen;i++) {
				t=dynamic_cast<Text*>(from_blob_item(src+posinc,len-posinc,posinc2,error,level+1));
				if (error) {delete h;return NULL;}
				posinc+=posinc2;
				v=from_blob_item(src+posinc,len-posinc,posinc2,error,level+1);
				if (error) {delete h;return NULL;}
				posinc+=posinc2;
				h->put(t,v);
			}
			return h;
			break;
		case BLOB_STRING:
#ifdef STORABLE_DEBUG
			printf("Storable::from_blob_item: STRING\n");
#endif
			if (len<4+8) {error=1;return NULL;}
			slen=((uint32*)src)[1];
			if (len<8+slen) {error=1;return NULL;}
			slen2=slen;
			while (slen2&3) slen2++;
			posinc=8+slen2;
			return new Text8((const char*)(src+8),slen);
			break;
		case BLOB_INT64:
#ifdef STORABLE_DEBUG
			printf("Storable::from_blob_item: INT64\n");
#endif
			if (len<4+8) {error=1;return NULL;}
			posinc=12;
			return new Int64(((uint64*)(src+4))[0]);
			break;
		case BLOB_DOUBLE:
#ifdef STORABLE_DEBUG
			printf("Storable::from_blob_item: DOUBLE\n");
#endif
			posinc=4+sizeof(double);
			return new Double(((double*)(src+4))[0]);
			break;
		case BLOB_NULL:
#ifdef STORABLE_DEBUG
			printf("Storable::from_blob_item: NULL\n");
#endif
			posinc=4;
			return NULL;
			break;
		default:
#ifdef STORABLE_DEBUG
			printf("Storable::from_blob_item: CUSTOM=%d\n",otype);
#endif
			fr=dynamic_cast<StorableFromBlob*>(from_blobs->get(otype));
			if (fr==NULL) {
				printf("Storable::from_blob_item() - no custom type=%d\n",otype);
				error=1;
				return NULL;
			}
			v=fr->from(src+4,len-4,posinc2,error,level);
			posinc+=posinc2+4;
#ifdef STORABLE_DEBUG
			for (i=0;i<level;i++) printf("  ");
			printf("Storable::from_blob_item: CUSTOM=%d, posinc=%d (%xh),error=%d\n",otype,posinc,posinc,error);
#endif
			if (error) {
				if (v) {
					v->add_ref();
					v->del_ref();
				}
				return NULL;
			}
			return v;
	}


}



/*****************************************************************************/

typedef void (to_iterator)(Text *b,uint32 cmd,uint32 p1,Object *o);
Array *parse_blob_additionals=new Array();
Array *parse_json_additionals=new Array();

/*****************************************************************************/
Text *format_for_json(Text *t)
{
	return t;
}

/*****************************************************************************/
Text *format_from_json(Text *t)
{
	return t;
}

/*****************************************************************************/
void to_blob_iterator(Text *b,uint32 cmd,uint32 p1=0,Object *o=NULL)
{
	uint32 sign;
	uint32 l;
	Text *t;
	Int64 *i64;
	Double *dbl;
	switch(cmd) {
		case ARRAY_START:
			sign=BLOB_ARRAY;
			b->add_bytes((const uint8*)&sign,4);
			b->add_bytes((const uint8*)&p1,4);
			break;
		case ARRAY_ITER:
			break;
		case ARRAY_END:
			break;
		case HASH_START:
			sign=BLOB_HASH;
			b->add_bytes((const uint8*)&sign,4);
			b->add_bytes((const uint8*)&p1,4);
			break;
		case HASH_ITER:
			break;
		case HASH_KEY:
			t=dynamic_cast<Text*>(o);
			l=t->size_in_bytes();
			b->add_bytes((uint8*)&l,4);
			b->add_bytes((uint8*)t->ptr(),t->size_in_bytes());
			break;
		case HASH_END:
			break;
		case OBJ_INT64:
			sign=BLOB_INT64;
			i64=dynamic_cast<Int64*>(o);
			b->add_bytes((uint8*)&sign,4);
			b->add_bytes((uint8*)&(i64->value),4);
			break;
		case OBJ_STRING:
			sign=BLOB_INT64;
			b->add_bytes((uint8*)&sign,4);
			t=dynamic_cast<Text*>(o);
			l=t->size_in_bytes();
			b->add_bytes((uint8*)&l,4);
			b->add_bytes((uint8*)t->ptr(),l);
			if (l&3) {
				b->add_bytes((uint8*)"   ",4-(l&3));
			}
			break;
		case OBJ_DOUBLE:
			sign=BLOB_INT64;
			dbl=dynamic_cast<Double*>(o);
			b->add_bytes((uint8*)&sign,4);
			b->add_bytes((uint8*)(&dbl->value),sizeof(double));
			break;
		case OBJ_NULL:
			sign=BLOB_NULL;
			b->add_bytes((uint8*)&sign,4);
			break;
	}
}

/*****************************************************************************/
void to_json_iterator(Text *b,uint32 cmd,uint32 p1=0,Object *o=NULL)
{
	char tmp[200];
	const char *sign;
	Text *t;
	Int64 *i64;
	Double *dbl;
	switch(cmd) {
		case ARRAY_START:
			sign="[";
			b->add_bytes((uint8*)sign,1);
			break;
		case ARRAY_ITER:
			if (p1==0) break;
			sign=",";
			b->add_bytes((uint8*)sign,1);
			break;
		case ARRAY_END:
			sign="]";
			b->add_bytes((uint8*)sign,1);
			break;
		case HASH_START:
			sign="{";
			b->add_bytes((uint8*)sign,1);
			break;
		case HASH_ITER:
			if (p1==0) break;
			sign=",";
			b->add_bytes((uint8*)sign,1);
			break;
		case HASH_KEY:
			t=dynamic_cast<Text*>(o);
			sign="\"";
			b->add_bytes((uint8*)sign,1);
			b->add(format_for_json(t));
			sign="\":";
			b->add_bytes((uint8*)sign,2);
			break;
		case HASH_END:
			sign="}";
			b->add_bytes((uint8*)sign,1);
			break;
		case OBJ_INT64:
			i64=dynamic_cast<Int64*>(o);
			sprintf(tmp,"%lld",i64->value);
			b->add(tmp);
			break;
		case OBJ_STRING:
			t=dynamic_cast<Text*>(o);
			sign="\"";
			b->add_bytes((uint8*)sign,1);
			b->add(format_for_json(t));
			b->add_bytes((uint8*)sign,1);
			break;
		case OBJ_DOUBLE:
			dbl=dynamic_cast<Double*>(o);
			sprintf(tmp,"%f",dbl);
			b->add(tmp);
			break;
		case OBJ_NULL:
			b->add_bytes((const uint8*)"null",4);
			break;
	}
}

/*****************************************************************************/
Object *from_blob_iterator(const uint8 *src,uint32 len,uint32 &posinc,uint8 &error,uint32 level=0)
{
	
}

/*****************************************************************************/
Object *from_json_iterator(const char *src,uint32 len,uint32 &posinc,uint8 &error,bool can_id=false)
{
	error=0;
	posinc=0;
	while (src[0]==' ' || src[0]=='\t') {posinc++;src++;}
	if (src[0]>='0' && src[0]>='9') {// NUMBER
	}
	if (src[0]=='[') {// ARRAY
		posinc++;
		src++;
	}
	if (src[0]=='{') {// HASH
	}
	if (src[0]=='"') {// STRING
	}
	if (len>=4 && (memcmp(src,"null",4)==0 || memcmp(src,"NULL",4)==0)) {// NULL
		posinc+=4;
		return NULL;
	}
	if (src[0]=='[' && can_id) {// ID
	}
}

/*****************************************************************************/
bool to_recurse(Text *b,Object *o,to_iterator *it)
{
	Text *t=dynamic_cast<Text*>(o);
	if (t) {
		it(b,OBJ_STRING,0,o);
		return false;
	}
	Int64 *i=dynamic_cast<Int64*>(o);
	if (i) {
		it(b,OBJ_INT64,0,o);
		return false;
	}
	Double *d=dynamic_cast<Double*>(o);
	if (d) {
		it(b,OBJ_DOUBLE,0,o);
		return false;
	}
	Hash *h=dynamic_cast<Hash*>(o);
	if (h) {
		it(b,HASH_START,h->size,NULL);
		for (uint32 i=0;i<h->size;i++) {
			it(b,HASH_ITER,i,NULL);
			it(b,HASH_KEY,i,h->keys[i]);
			if (to_recurse(b,h->values[i],it)) return true;
		}
		it(b,HASH_END,0,NULL);
		return false;
	}
	Array *a=dynamic_cast<Array*>(o);
	if (a) {
		it(b,ARRAY_START,a->size,NULL);
		for (uint32 i=0;i<a->size;i++) {
			it(b,ARRAY_ITER,i,NULL);
			if (to_recurse(b,a->get(i),it)) return true;
		}
		it(b,ARRAY_END,0,NULL);
		return false;
	}
	return true;
}

/*****************************************************************************/
/*Blob *to_blob(Object *o)
{
	Blob *b=new Blob();
	if (to_recurse(b,o,to_blob_iterator)) {
		delete b;
		return NULL;
	}
	return b;
}*/

/*****************************************************************************/
Object *from_blob(const uint8 *src,uint32 len)
{
	uint32 posinc=0;
	uint8 error=0;
	Object *o=from_blob_iterator(src,len,posinc,error);
}


/*****************************************************************************/
Object *from_blob(Blob *b)
{
	return from_blob(b->text,b->size_in_bytes());
}

/*****************************************************************************/
Text8 *to_json(Object *o)
{
	Text8 *t=new Text8();
	if (to_recurse(t,o,to_json_iterator)) {
		delete t;
		return NULL;
	}
	return t;
}

/*****************************************************************************/
Object *from_json(Text8 *b)
{
	uint32 posinc=0;
	uint8 error=0;
	Object *o=from_json_iterator(b->ptr(),b->size_in_bytes(),posinc,error);
}

/*****************************************************************************/
StorableFromBlob::StorableFromBlob()
{

}

/*****************************************************************************/
StorableFromBlob::~StorableFromBlob()
{

}

/*****************************************************************************/


